/*
 * Decompiled with CFR 0.152.
 */
package quiz;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import quiz.DoWhileLoopStatement;
import quiz.ExpressionStatement;
import quiz.ForLoopStatement;
import quiz.GeneratorRule;
import quiz.IfStatement;
import quiz.IntDeclarationStatement;
import quiz.LoopParts;
import quiz.ProgrammingBlock;
import quiz.ProgrammingStatement;
import quiz.QuizFunction;
import quiz.ReturnStatement;
import quiz.WhileLoopStatement;
import quiz.expressions.AddExpression;
import quiz.expressions.AssignmentExpression;
import quiz.expressions.DivideEqualsExpression;
import quiz.expressions.DivideExpression;
import quiz.expressions.EqualsExpression;
import quiz.expressions.GreaterEqualExpression;
import quiz.expressions.GreaterThanExpression;
import quiz.expressions.IntLiteralExpression;
import quiz.expressions.LessEqualExpression;
import quiz.expressions.LessThanExpression;
import quiz.expressions.LogicalAndExpression;
import quiz.expressions.LogicalNotExpression;
import quiz.expressions.LogicalOrExpression;
import quiz.expressions.MinusEqualsExpression;
import quiz.expressions.ModuloEqualsExpression;
import quiz.expressions.ModuloExpression;
import quiz.expressions.MultiplyExpression;
import quiz.expressions.NotEqualsExpression;
import quiz.expressions.PlusEqualsExpression;
import quiz.expressions.PostDecrementExpression;
import quiz.expressions.PostIncrementExpression;
import quiz.expressions.PreDecrementExpression;
import quiz.expressions.PreIncrementExpression;
import quiz.expressions.ProgrammingExpression;
import quiz.expressions.SubtractExpression;
import quiz.expressions.TimesEqualsExpression;
import quiz.expressions.VariableExpression;

public class ProblemGenerator {
    private int maxConditionalDepth = 4;
    private int maxLoopDepth = 3;
    private int ifsLeft;
    private int loopsLeft;
    private int loopScore;
    private int linesScore;
    private int loopNesting;
    private Set<String> loopVariables = new HashSet<String>();
    private Set<String> usedVariables = new HashSet<String>();

    public QuizFunction generateProblem(int n, int n2) {
        this.loopScore = 1;
        this.linesScore = 0;
        this.loopNesting = 0;
        this.loopVariables.clear();
        this.usedVariables.clear();
        this.ifsLeft = n;
        this.loopsLeft = n2;
        QuizFunction quizFunction = new QuizFunction();
        this.populateBlock(quizFunction, 0);
        List<String> list = quizFunction.availableVariables();
        String string = list.get((int)(Math.random() * (double)list.size()));
        quizFunction.statements.add(new ReturnStatement(quizFunction, 1, new VariableExpression(string)));
        quizFunction.difficulty = this.difficultyScore();
        return quizFunction;
    }

    public int difficultyScore() {
        return this.linesScore * this.loopScore;
    }

    private void populateBlock(ProgrammingBlock programmingBlock, int n) {
        ++n;
        int n2 = (int)(Math.random() * 2.0 + 2.0);
        block0: do {
            for (int i = 0; i < n2; ++i) {
                ProgrammingStatement programmingStatement = this.generateStatement(n, programmingBlock, i);
                programmingBlock.statements.add(programmingStatement);
                if (programmingStatement instanceof ReturnStatement) break;
            }
            if (n <= 0) continue;
            while (programmingBlock.statements.get(programmingBlock.statements.size() - 1) instanceof IntDeclarationStatement) {
                IntDeclarationStatement intDeclarationStatement = (IntDeclarationStatement)programmingBlock.statements.get(programmingBlock.statements.size() - 1);
                programmingBlock.undeclareVariable(intDeclarationStatement.name);
                programmingBlock.statements.remove(intDeclarationStatement);
                if (programmingBlock.statements.size() != 0) continue;
                continue block0;
            }
        } while (programmingBlock.statements.size() < 1);
    }

    public ProgrammingStatement generateStatement(int n, ProgrammingStatement programmingStatement, int n2) {
        ++this.linesScore;
        ArrayList<GeneratorRule> arrayList = new ArrayList<GeneratorRule>();
        List<String> list = programmingStatement.availableVariables();
        if (list.size() == 0) {
            arrayList.add(GeneratorRule.Declare);
        } else {
            if (n < 3 && this.loopsLeft > 0) {
                arrayList.add(GeneratorRule.ForLoop);
                arrayList.add(GeneratorRule.WhileLoop);
                arrayList.add(GeneratorRule.DoWhileLoop);
            }
            if (n < 4 && this.ifsLeft > 0) {
                arrayList.add(GeneratorRule.IfStatement);
                arrayList.add(GeneratorRule.IfElse);
            }
            if (list.size() < 15) {
                arrayList.add(GeneratorRule.Declare);
            }
            if (list.size() > 1) {
                arrayList.add(GeneratorRule.Assign);
                arrayList.add(GeneratorRule.PlusEquals);
                arrayList.add(GeneratorRule.MinusEquals);
                arrayList.add(GeneratorRule.TimesEquals);
                arrayList.add(GeneratorRule.DivideEquals);
                arrayList.add(GeneratorRule.ModuloEquals);
            }
            if (n > 1 && n2 > 0) {
                arrayList.add(GeneratorRule.ReturnStatement);
            }
        }
        int n3 = (int)(Math.random() * (double)arrayList.size());
        GeneratorRule generatorRule = (GeneratorRule)((Object)arrayList.get(n3));
        switch (generatorRule) {
            case ForLoop: {
                return this.generateFor(n, programmingStatement);
            }
            case WhileLoop: {
                return this.generateWhile(n, programmingStatement);
            }
            case DoWhileLoop: {
                return this.generateDoWhile(n, programmingStatement);
            }
            case IfStatement: {
                return this.generateIfStatement(n, programmingStatement);
            }
            case IfElse: {
                return this.generateIfElse(n, programmingStatement);
            }
            case Declare: {
                return this.generateDeclare(n, programmingStatement);
            }
            case Assign: {
                return this.generateAssign(n, programmingStatement, AssignmentExpression.class);
            }
            case PlusEquals: {
                return this.generateAssign(n, programmingStatement, PlusEqualsExpression.class);
            }
            case MinusEquals: {
                return this.generateAssign(n, programmingStatement, MinusEqualsExpression.class);
            }
            case TimesEquals: {
                return this.generateAssign(n, programmingStatement, TimesEqualsExpression.class);
            }
            case DivideEquals: {
                return this.generateAssign(n, programmingStatement, DivideEqualsExpression.class);
            }
            case ModuloEquals: {
                return this.generateAssign(n, programmingStatement, ModuloEqualsExpression.class);
            }
            case ReturnStatement: {
                return this.generateReturn(n, programmingStatement);
            }
        }
        System.out.println("Unknown enum: " + (Object)((Object)generatorRule));
        return null;
    }

    private ProgrammingExpression generateExpression(int n, ProgrammingStatement programmingStatement) {
        double d = Math.random();
        List<String> list = programmingStatement.availableVariables();
        if (n > 2 || d > 0.7 || list.size() == 0 && d > 0.5) {
            if (Math.random() > 0.5 || list.size() == 0) {
                return new IntLiteralExpression((int)(Math.random() * 21.0 - 11.0));
            }
            return new VariableExpression(list.get((int)(Math.random() * (double)list.size())));
        }
        if (d > 0.5 && list.size() > this.loopVariables.size()) {
            for (String string : this.loopVariables) {
                list.remove(string);
            }
            String string = list.get((int)(Math.random() * (double)list.size()));
            if ((d = (d - 0.5) / 0.2) > 0.75) {
                return new PreDecrementExpression(string);
            }
            if (d > 0.5) {
                return new PreIncrementExpression(string);
            }
            if (d > 0.25) {
                return new PostDecrementExpression(string);
            }
            return new PostIncrementExpression(string);
        }
        if ((d /= 0.5) > 1.0) {
            d -= 1.0;
        }
        ProgrammingExpression programmingExpression = this.generateExpression(n + 1, programmingStatement);
        ProgrammingExpression programmingExpression2 = d > 0.8 ? new IntLiteralExpression((int)(Math.random() * 10.0 + 1.0)) : this.generateExpression(n + 1, programmingStatement);
        if (d > 0.9) {
            return new DivideExpression(programmingExpression, programmingExpression2);
        }
        if (d > 0.8) {
            return new ModuloExpression(programmingExpression, programmingExpression2);
        }
        if (d > 0.53) {
            return new AddExpression(programmingExpression, programmingExpression2);
        }
        if (d > 0.27) {
            return new MultiplyExpression(programmingExpression, programmingExpression2);
        }
        return new SubtractExpression(programmingExpression, programmingExpression2);
    }

    private ProgrammingExpression generateConditional(int n, ProgrammingStatement programmingStatement) {
        double d = Math.random();
        List<String> list = programmingStatement.availableVariables();
        if (d > 0.6 || n > 2) {
            ProgrammingExpression programmingExpression = this.generateExpression(2, programmingStatement);
            ProgrammingExpression programmingExpression2 = this.generateExpression(2, programmingStatement);
            if ((d = (d - 0.5) / 0.2) > 0.83) {
                return new LessThanExpression(programmingExpression, programmingExpression2);
            }
            if (d > 0.66) {
                return new GreaterThanExpression(programmingExpression, programmingExpression2);
            }
            if (d > 0.5) {
                return new LessEqualExpression(programmingExpression, programmingExpression2);
            }
            if (d > 0.33) {
                return new GreaterEqualExpression(programmingExpression, programmingExpression2);
            }
            if (d > 0.16) {
                return new EqualsExpression(programmingExpression, programmingExpression2);
            }
            return new NotEqualsExpression(programmingExpression, programmingExpression2);
        }
        if (d > 0.2) {
            ProgrammingExpression programmingExpression = this.generateConditional(n + 1, programmingStatement);
            ProgrammingExpression programmingExpression3 = this.generateConditional(n + 1, programmingStatement);
            if ((d /= 0.5) > 0.5) {
                return new LogicalAndExpression(programmingExpression, programmingExpression3);
            }
            return new LogicalOrExpression(programmingExpression, programmingExpression3);
        }
        ProgrammingExpression programmingExpression = this.generateConditional(n + 1, programmingStatement);
        return new LogicalNotExpression(programmingExpression);
    }

    private ProgrammingStatement generateIfStatement(int n, ProgrammingStatement programmingStatement) {
        --this.ifsLeft;
        ProgrammingExpression programmingExpression = this.generateConditional(n, programmingStatement);
        IfStatement ifStatement = new IfStatement(programmingStatement, n, programmingExpression);
        ProgrammingBlock programmingBlock = new ProgrammingBlock(ifStatement, n);
        this.populateBlock(programmingBlock, n);
        ifStatement.ifBlock = programmingBlock;
        return ifStatement;
    }

    private ProgrammingStatement generateIfElse(int n, ProgrammingStatement programmingStatement) {
        --this.ifsLeft;
        ProgrammingExpression programmingExpression = this.generateConditional(n, programmingStatement);
        IfStatement ifStatement = new IfStatement(programmingStatement, n, programmingExpression);
        ProgrammingBlock programmingBlock = new ProgrammingBlock(ifStatement, n);
        ProgrammingBlock programmingBlock2 = new ProgrammingBlock(ifStatement, n);
        this.populateBlock(programmingBlock, n);
        this.populateBlock(programmingBlock2, n);
        ifStatement.ifBlock = programmingBlock;
        ifStatement.elseBlock = programmingBlock2;
        return ifStatement;
    }

    private String getUnusedVariable() {
        String string;
        while (this.usedVariables.contains(string = Character.toString((char)(Math.random() * 26.0 + 97.0)))) {
        }
        this.usedVariables.add(string);
        return string;
    }

    private ProgrammingStatement generateDeclare(int n, ProgrammingStatement programmingStatement) {
        String string = this.getUnusedVariable();
        ProgrammingExpression programmingExpression = this.generateExpression(0, programmingStatement);
        programmingStatement.declareVariable(string, 0);
        return new IntDeclarationStatement(programmingStatement, n, string, programmingExpression);
    }

    /*
     * WARNING - void declaration
     */
    private ProgrammingStatement generateAssign(int n, ProgrammingStatement programmingStatement, Class<?> clazz) {
        List<String> list = programmingStatement.availableVariables();
        for (String object2 : this.loopVariables) {
            list.remove(object2);
        }
        String string = list.get((int)(Math.random() * (double)list.size()));
        if (clazz == DivideEqualsExpression.class) {
            IntLiteralExpression intLiteralExpression = new IntLiteralExpression((int)(Math.random() * 5.0 + 1.0));
        } else if (clazz == ModuloEqualsExpression.class) {
            IntLiteralExpression intLiteralExpression = new IntLiteralExpression((int)(Math.random() * 20.0 + 2.0));
        } else {
            ProgrammingExpression programmingExpression = this.generateExpression(0, programmingStatement);
        }
        try {
            void var6_10;
            Constructor<?> constructor = clazz.getConstructor(String.class, ProgrammingExpression.class);
            ProgrammingExpression programmingExpression = (ProgrammingExpression)constructor.newInstance(string, var6_10);
            return new ExpressionStatement(programmingStatement, n, programmingExpression);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    private ProgrammingStatement generateReturn(int n, ProgrammingStatement programmingStatement) {
        return new ReturnStatement(programmingStatement, n, this.generateExpression(0, programmingStatement));
    }

    private LoopParts generateLoopParts(int n, ProgrammingStatement programmingStatement, ProgrammingStatement programmingStatement2) {
        this.loopScore += 1 + this.loopNesting;
        LoopParts loopParts = new LoopParts();
        int n2 = (int)(Math.random() * 31.0 - 11.0);
        int n3 = (int)(Math.random() * 31.0 - 11.0);
        String string = this.getUnusedVariable();
        this.loopVariables.add(string);
        loopParts.initializer = new IntDeclarationStatement(programmingStatement2, n, string, new IntLiteralExpression(n2));
        loopParts.body = new ProgrammingBlock(programmingStatement2, n);
        if (n2 < n3) {
            if (n2 > 0 && Math.random() > 0.7) {
                n3 = (int)(Math.random() * 100.0 + 10.0 + (double)n2);
                loopParts.increment = new ExpressionStatement(loopParts.body, n + 1, new TimesEqualsExpression(string, new IntLiteralExpression((int)(Math.random() * 3.0 + 2.0))));
            } else {
                loopParts.increment = Math.random() > 0.6 ? new ExpressionStatement(loopParts.body, n + 1, new PostIncrementExpression(string)) : new ExpressionStatement(loopParts.body, n + 1, new PlusEqualsExpression(string, new IntLiteralExpression((int)(Math.random() * (double)(n3 - n2) + 1.0))));
            }
            loopParts.condition = Math.random() > 0.5 ? new LessThanExpression(new VariableExpression(string), new IntLiteralExpression(n3)) : new LessEqualExpression(new VariableExpression(string), new IntLiteralExpression(n3));
        } else {
            if (Math.random() > 0.85) {
                n2 = (int)(Math.random() * 100.0 + 10.0);
                n3 = 0;
                loopParts.increment = new ExpressionStatement(loopParts.body, n + 1, new DivideEqualsExpression(string, new IntLiteralExpression((int)(Math.random() * 3.0 + 2.0))));
            } else {
                loopParts.increment = Math.random() > 0.6 ? new ExpressionStatement(loopParts.body, n + 1, new PostDecrementExpression(string)) : new ExpressionStatement(loopParts.body, n + 1, new MinusEqualsExpression(string, new IntLiteralExpression((int)(Math.random() * (double)(n2 - n3) + 1.0))));
            }
            loopParts.condition = Math.random() > 0.5 || n3 == 0 ? new GreaterThanExpression(new VariableExpression(string), new IntLiteralExpression(n3)) : new GreaterEqualExpression(new VariableExpression(string), new IntLiteralExpression(n3));
        }
        programmingStatement2.declareVariable(string, 0);
        ++this.loopNesting;
        this.populateBlock(loopParts.body, n);
        --this.loopNesting;
        return loopParts;
    }

    private ProgrammingStatement generateFor(int n, ProgrammingStatement programmingStatement) {
        --this.loopsLeft;
        ForLoopStatement forLoopStatement = new ForLoopStatement(programmingStatement, n);
        LoopParts loopParts = this.generateLoopParts(n, programmingStatement, forLoopStatement);
        forLoopStatement.initializer = loopParts.initializer;
        forLoopStatement.condition = loopParts.condition;
        forLoopStatement.increment = loopParts.increment;
        forLoopStatement.body = loopParts.body;
        return forLoopStatement;
    }

    private ProgrammingStatement generateWhile(int n, ProgrammingStatement programmingStatement) {
        --this.loopsLeft;
        WhileLoopStatement whileLoopStatement = new WhileLoopStatement(programmingStatement, n);
        LoopParts loopParts = this.generateLoopParts(n, programmingStatement, whileLoopStatement);
        ProgrammingBlock programmingBlock = (ProgrammingBlock)programmingStatement;
        programmingBlock.statements.add((int)(Math.random() * (double)programmingBlock.statements.size()), loopParts.initializer);
        loopParts.body.statements.add((int)(Math.random() * (double)loopParts.body.statements.size()), loopParts.increment);
        whileLoopStatement.body = loopParts.body;
        whileLoopStatement.condition = loopParts.condition;
        return whileLoopStatement;
    }

    private ProgrammingStatement generateDoWhile(int n, ProgrammingStatement programmingStatement) {
        --this.loopsLeft;
        DoWhileLoopStatement doWhileLoopStatement = new DoWhileLoopStatement(programmingStatement, n);
        LoopParts loopParts = this.generateLoopParts(n, programmingStatement, doWhileLoopStatement);
        ProgrammingBlock programmingBlock = (ProgrammingBlock)programmingStatement;
        programmingBlock.statements.add((int)(Math.random() * (double)programmingBlock.statements.size()), loopParts.initializer);
        loopParts.body.statements.add((int)(Math.random() * (double)loopParts.body.statements.size()), loopParts.increment);
        doWhileLoopStatement.body = loopParts.body;
        doWhileLoopStatement.condition = loopParts.condition;
        return doWhileLoopStatement;
    }
}

