/*
 * Decompiled with CFR 0.152.
 */
package quiz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ProgrammingStatement {
    protected ProgrammingStatement parent = null;
    protected Integer indentLevel = 0;
    protected Map<String, Integer> variables = new HashMap<String, Integer>();

    public void declareVariable(String string, Integer n) {
        this.variables.put(string, n);
    }

    public void undeclareVariable(String string) {
        if (!this.variables.containsKey(string) && this.parent != null) {
            this.parent.undeclareVariable(string);
        } else {
            this.variables.remove(string);
        }
    }

    public void setValue(String string, int n) {
        if (!this.variables.containsKey(string) && this.parent != null) {
            this.parent.setValue(string, n);
        } else {
            this.variables.put(string, n);
        }
    }

    public Integer getValue(String string) {
        if (!this.variables.containsKey(string) && this.parent != null) {
            return this.parent.getValue(string);
        }
        return this.variables.get(string);
    }

    public List<String> availableVariables() {
        ArrayList<String> arrayList = this.parent == null ? new ArrayList() : this.parent.availableVariables();
        for (String string : this.variables.keySet()) {
            if (string.charAt(0) == '@') continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public abstract void execute();

    public String indent() {
        String string = "";
        for (int i = 0; i < this.indentLevel; ++i) {
            string = string + "\t";
        }
        return string;
    }
}

